#ifndef __CS_LAGR_HEADERS_H__
#define __CS_LAGR_HEADERS_H__

/*============================================================================
 * Global code_saturne headers file for easier include
 *============================================================================*/

/*
  This file is part of code_saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2025 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*----------------------------------------------------------------------------
 * Local headers
 *----------------------------------------------------------------------------*/

#include "lagr/cs_lagr.h"
#include "lagr/cs_lagr_adh.h"
#include "lagr/cs_lagr_car.h"
#include "lagr/cs_lagr_clogging.h"
#include "lagr/cs_lagr_coupling.h"
#include "lagr/cs_lagr_deposition_model.h"
#include "lagr/cs_lagr_dlvo.h"
#include "lagr/cs_lagr_orientation.h"
#include "lagr/cs_lagr_extract.h"
#include "lagr/cs_lagr_aux_mean_fluid_quantities.h"
#include "lagr/cs_lagr_head_losses.h"
#include "lagr/cs_lagr_injection.h"
#include "lagr/cs_lagr_lec.h"
#include "lagr/cs_lagr_log.h"
#include "lagr/cs_lagr_new.h"
#include "lagr/cs_lagr_options.h"
#include "lagr/cs_lagr_particle.h"
#include "lagr/cs_lagr_poisson.h"
#include "lagr/cs_lagr_porosity.h"
#include "lagr/cs_lagr_post.h"
#include "lagr/cs_lagr_precipitation_model.h"
#include "lagr/cs_lagr_print.h"
#include "lagr/cs_lagr_prototypes.h"
#include "lagr/cs_lagr_query.h"
#include "lagr/cs_lagr_restart.h"
#include "lagr/cs_lagr_resuspension.h"
#include "lagr/cs_lagr_roughness.h"
#include "lagr/cs_lagr_sde.h"
#include "lagr/cs_lagr_sde_model.h"
#include "lagr/cs_lagr_stat.h"
#include "lagr/cs_lagr_tracking.h"

/*----------------------------------------------------------------------------*/

#endif /* __CS_LAGR_HEADERS_H__ */
