#ifndef __CS_CDO_HEADERS_H__
#define __CS_CDO_HEADERS_H__

/*============================================================================
 * Global code_saturne headers file for easier include
 *============================================================================*/

/*
  This file is part of code_saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2025 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*----------------------------------------------------------------------------
 * Local headers
 *----------------------------------------------------------------------------*/

#include "cdo/cs_advection_field.h"
#include "cdo/cs_basis_func.h"
#include "cdo/cs_cdo_advection.h"
#include "cdo/cs_cdo_assembly.h"
#include "cdo/cs_cdo_bc.h"
#include "cdo/cs_cdo_connect.h"
#include "cdo/cs_cdo_diffusion.h"
#include "cdo/cs_cdo_field_interpolation.h"
#include "cdo/cs_cdo_local.h"
#include "cdo/cs_cdo_main.h"
#include "cdo/cs_cdo_quantities.h"
#include "cdo/cs_cdo_solve.h"
#include "cdo/cs_cdo_system.h"
#include "cdo/cs_cdo_toolbox.h"
#include "cdo/cs_cdo_turbulence.h"
#include "cdo/cs_cdocb_scaleq.h"
#include "cdo/cs_cdocb_scaleq_sles.h"
#include "cdo/cs_cdoeb_vecteq.h"
#include "cdo/cs_cdofb_ac.h"
#include "cdo/cs_cdofb_monolithic.h"
#include "cdo/cs_cdofb_monolithic_sles.h"
#include "cdo/cs_cdofb_navsto.h"
#include "cdo/cs_cdofb_predco.h"
#include "cdo/cs_cdofb_scaleq.h"
#include "cdo/cs_cdofb_vecteq.h"
#include "cdo/cs_cdovb_scaleq.h"
#include "cdo/cs_cdovb_scalsys.h"
#include "cdo/cs_cdovb_vecteq.h"
#include "cdo/cs_cdovcb_scaleq.h"
#include "cdo/cs_dbg.h"
#include "cdo/cs_domain.h"
#include "cdo/cs_domain_op.h"
#include "cdo/cs_domain_setup.h"
#include "cdo/cs_enforcement.h"
#include "cdo/cs_equation.h"
#include "cdo/cs_equation_bc.h"
#include "cdo/cs_equation_builder.h"
#include "cdo/cs_equation_param.h"
#include "cdo/cs_equation_system.h"
#include "cdo/cs_evaluate.h"
#include "cdo/cs_flag.h"
#include "cdo/cs_hho_builder.h"
#include "cdo/cs_hho_scaleq.h"
#include "cdo/cs_hho_stokes.h"
#include "cdo/cs_hho_vecteq.h"
#include "cdo/cs_hodge.h"
#include "cdo/cs_iter_algo.h"
#include "cdo/cs_macfb_vecteq.h"
#include "cdo/cs_maxwell.h"
#include "cdo/cs_mesh_deform.h"
#include "cdo/cs_navsto_coupling.h"
#include "cdo/cs_navsto_param.h"
#include "cdo/cs_navsto_system.h"
#include "cdo/cs_param_cdo.h"
#include "cdo/cs_property.h"
#include "cdo/cs_quadrature.h"
#include "cdo/cs_reco.h"
#include "cdo/cs_reco_cw.h"
#include "alge/cs_saddle_solver.h"
#include "cdo/cs_scheme_geometry.h"
#include "cdo/cs_sdm.h"
#include "cdo/cs_solid_selection.h"
#include "cdo/cs_solidification.h"
#include "cdo/cs_source_term.h"
#include "cdo/cs_static_condensation.h"
#include "cdo/cs_thermal_system.h"
#include "cdo/cs_walldistance.h"
#include "cdo/cs_xdef.h"
#include "cdo/cs_xdef_cw_eval.h"
#include "cdo/cs_xdef_eval.h"

/*----------------------------------------------------------------------------*/

#endif /* __CS_CDO_HEADERS_H__ */
