dnl--------------------------------------------------------------------------------
dnl
dnl This file is part of code_saturne, a general-purpose CFD tool.
dnl
dnl Copyright (C) 1998-2024 EDF S.A.
dnl
dnl This program is free software; you can redistribute it and/or modify it under
dnl the terms of the GNU General Public License as published by the Free Software
dnl Foundation; either version 2 of the License, or (at your option) any later
dnl version.
dnl
dnl This program is distributed in the hope that it will be useful, but WITHOUT
dnl ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
dnl FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
dnl details.
dnl
dnl You should have received a copy of the GNU General Public License along with
dnl this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
dnl Street, Fifth Floor, Boston, MA 02110-1301, USA.
dnl
dnl--------------------------------------------------------------------------------

# CS_AC_TEST_BLAS([use_threads])
#----------------
# modifies or sets cs_have_blas, BLAS_CPPFLAGS, BLAS_LDFLAGS, and BLAS_LIBS
# depending on libraries found

AC_DEFUN([CS_AC_TEST_BLAS], [

cs_have_blas=no

AC_ARG_WITH(blas,
            [AS_HELP_STRING([--with-blas=PATH],
                            [specify prefix directory for BLAS])],
            [if test "x$withval" = "x"; then
               with_blas=yes
             fi],
            [with_blas=no])

AC_ARG_WITH(blas-include,
            [AS_HELP_STRING([--with-blas-include=PATH],
                            [specify directory for BLAS include files])],
            [if test "x$with_blas" = "xcheck"; then
               with_blas=yes
             fi
             BLAS_CPPFLAGS="-I$with_blas_include"],
            [if test "x$with_blas" != "xno" -a "x$with_blas" != "xyes" \
	          -a "x$with_blas" != "xcheck"; then
               BLAS_CPPFLAGS="-I$with_blas/include"
             fi])

AC_ARG_WITH(blas-lib,
            [AS_HELP_STRING([--with-blas-lib=PATH],
                            [specify directory for BLAS library])],
            [if test "x$with_blas" = "xcheck"; then
               with_blas=yes
             fi
             BLAS_LDFLAGS="-L$with_blas_lib"
             # Add the libdir to the runpath as BLAS may not be libtoolized
             BLASRUNPATH="${LDRPATH}${with_blas_lib}"],
            [if test "x$with_blas" != "xno" -a "x$with_blas" != "xyes" \
	          -a "x$with_blas" != "xcheck"; then
               BLAS_LDFLAGS="-L$with_blas/lib"
               # Add the libdir to the runpath as BLAS may not be libtoolized
               BLASRUNPATH="${LDRPATH}${with_blas}/lib"
             fi])

AC_ARG_WITH(blas-type,
            [AS_HELP_STRING([--with-blas-type=NAME],
                            [force ATLAS, MKL, ...])])

AC_ARG_WITH(blas-libs,
            [AS_HELP_STRING([--with-blas-libs=LIBS],
                            [specify BLAS libraries])])

if test "x$with_blas" != "xno" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  # Test for Intel MKL libraries

  if test "x$with_blas_type" = "x" -o "x$with_blas_type" = "xMKL" ; then

    if test "x$with_blas_lib" = "x" ; then
      mkl_lib="$with_blas/lib"
      if test `uname -m` = x86_64 ; then
        if test -d ${mkl_lib}/intel64 ; then
          mkl_sub_lib="/intel64"
        elif test -d ${mkl_lib}/em64t ; then
          mkl_sub_lib="/em64t"
        fi
      else
        if test -d ${mkl_lib}/ia32 ; then
          mkl_sub_lib="/ia32"
        elif test -d ${mkl_lib}/32 ; then
          mkl_sub_lib="/32"
        fi
      fi
    fi

    if test "x$with_blas_libs" = "x"; then

      if test "x$with_blas_libs" != "x" -a "x$with_blas_type" = "xMKL"; then
        BLAS_LIBS="$with_blas_libs"
      else
        BLAS_LIBS=""
        if test "x$cs_have_sycl" = "xyes" ; then
          BLAS_LIBS="-lmkl_sycl_blas -lmkl_sycl_sparse"
        fi
        case `uname -m` in
          *64)
            if test "x$cs_have_long_lnum" = "xyes"; then
              BLAS_LIBS="${BLAS_LIBS} -lmkl_intel_ilp64 -lmkl_core"
            else
              BLAS_LIBS="${BLAS_LIBS} -lmkl_intel_lp64 -lmkl_core"
            fi
            ;;
          *)
            BLAS_LIBS="${BLAS_LIBS} -lmkl_intel -lmkl_core"
            ;;
        esac
        if test "$1" = "yes" ; then # Threaded version ?
          BLAS_LIBS="${BLAS_LIBS} -lmkl_intel_thread"
        else
          BLAS_LIBS="${BLAS_LIBS} -lmkl_sequential"
        fi
      fi

      CPPFLAGS="${saved_CPPFLAGS} ${BLAS_CPPFLAGS}"
      LDFLAGS="${saved_LDFLAGS} ${BLAS_LDFLAGS}${mkl_sub_lib}"
      LIBS=" ${BLAS_LIBS} ${saved_LIBS}"

      AC_MSG_CHECKING([for MKL libraries])
      AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <mkl_cblas.h>]],
                     [[ cblas_ddot(0, 0, 0, 0, 0); ]])],
                     [ AC_DEFINE([HAVE_MKL], 1, [MKL libraries support])
                       cs_have_blas=yes; with_blas_type=MKL ],
                     [cs_have_blas=no])
      AC_MSG_RESULT($cs_have_blas)

      if test "x$cs_have_blas" = "xyes" ; then
        AC_MSG_CHECKING([for MKL sparse inspector/executor API])
        AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <mkl_spblas.h>]],
                       [[ mkl_sparse_d_create_csr(0, 0, 0, 0, 0, 0, 0, 0); ]])],
                       [ AC_DEFINE([HAVE_MKL_SPARSE_IE], 1, [MKL sparse BLAS inspector/executor API]) ],
                       [])
      fi

    fi

    if test "x$with_blas_type" = "xMKL" ; then
      BLAS_LDFLAGS="${BLAS_LDFLAGS}${mkl_sub_lib}"
      BLASRUNPATH="${BLASRUNPATH}${mkl_sub_lib}"
    fi
    unset mkl_sub_lib

  fi

  # Test for ATLAS BLAS

  if test "x$with_blas_type" = "x" -o "x$with_blas_type" = "xATLAS" ; then

    if test "$1" = "yes" -o "x$with_blas_libs" = "x"; then # Threaded version ?

      BLAS_LIBS="-lptcblas -latlas -lpthread"

      CPPFLAGS="${saved_CPPFLAGS} ${BLAS_CPPFLAGS}"
      LDFLAGS="${saved_LDFLAGS} ${BLAS_LDFLAGS}"
      LIBS=" ${BLAS_LIBS} ${saved_LIBS}"

      AC_MSG_CHECKING([for threaded ATLAS BLAS])
      AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <cblas.h>]],
                     [[ cblas_ddot(0, 0, 0, 0, 0); ]])],
                     [ AC_DEFINE([HAVE_ATLAS], 1, [ATLAS BLAS support])
                       cs_have_blas=yes; with_blas_type=ATLAS ],
                     [cs_have_blas=no])
      AC_MSG_RESULT($cs_have_blas)
    fi

    if test "$cs_have_blas" = "no" ; then # Test for non-threaded version
                                          # or explicitely specified libs second
      if test "x$with_blas_libs" != "x" -a "x$with_blas_type" = "xATLAS"; then
        BLAS_LIBS="$with_blas_libs"
      else
        BLAS_LIBS="-lcblas -latlas"
      fi

      CPPFLAGS="${saved_CPPFLAGS} ${BLAS_CPPFLAGS}"
      LDFLAGS="${saved_LDFLAGS} ${BLAS_LDFLAGS}"
      LIBS=" ${BLAS_LIBS} ${saved_LIBS}"

      AC_MSG_CHECKING([for ATLAS BLAS])
      AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <cblas.h>]],
                     [[ cblas_ddot(0, 0, 0, 0, 0); ]])],
                     [ AC_DEFINE([HAVE_ATLAS], 1, [ATLAS BLAS support])
                       cs_have_blas=yes; with_blas_type=ATLAS ],
                     [cs_have_blas=no])
      AC_MSG_RESULT($cs_have_blas)
    fi

  fi

  # Test for ArmPL BLAS

  if test "x$with_blas_type" = "x" -o "x$with_blas_type" = "xARMPL" ; then

    if test "x$with_blas_libs" = "x" ; then
      if  test "x$enable_shared" = xyes ; then
        if test "$cs_have_openmp" = "yes" ; then # Threaded version ?
          BLAS_LIBS="-larmpl_mp -lm"
        else
	  BLAS_LIBS="-larmpl -lm"
        fi
      else
        if test "$cs_have_openmp" = "yes" ; then # Threaded version ?
          BLAS_LIBS="$ARMPL_DIR/lib/libarmpl_mp.a"
        else
          BLAS_LIBS="$ARMPL_DIR/lib/libarmpl.a"
        fi
      fi
    else
      BLAS_LIBS="$with_blas_libs"
    fi

    CPPFLAGS="${saved_CPPFLAGS} ${BLAS_CPPFLAGS}"
    LDFLAGS="${saved_LDFLAGS} ${BLAS_LDFLAGS}"
    LIBS=" ${BLAS_LIBS} ${saved_LIBS}"

    AC_MSG_CHECKING([for ArmPL libraries])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <cblas.h>]],
                   [[ cblas_ddot(0, 0, 0, 0, 0); ]])],
                   [ AC_DEFINE([HAVE_ARMPL], 1, [ArmPL BLAS support])
                     cs_have_blas=yes; with_blas_type=ARMPL ],
                   [cs_have_blas=no])
    AC_MSG_RESULT($cs_have_blas)

  fi

  # Test for generic C BLAS

  if test "x$with_blas_type" = "x" -o "x$with_blas_type" = "xBLAS" ; then

    if test "x$with_blas_libs" != "x" ; then
      BLAS_LIBS="$with_blas_libs"
    else
      BLAS_LIBS="-lcblas -lblas"
    fi

    CPPFLAGS="${saved_CPPFLAGS} ${BLAS_CPPFLAGS}"
    LDFLAGS="${saved_LDFLAGS} ${BLAS_LDFLAGS}"
    LIBS=" ${BLAS_LIBS} ${saved_LIBS}"

    AC_MSG_CHECKING([for legacy C BLAS])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <cblas.h>]],
                   [[ cblas_ddot(0, 0, 0, 0, 0); ]])],
                   [ AC_DEFINE([HAVE_CBLAS], 1, [C BLAS support])
                     cs_tmp_have_cblas=yes; with_blas_type=BLAS ],
                   [cs_tmp_have_cblas=no])
    AC_MSG_RESULT($cs_tmp_have_cblas)

    if test "x$cs_tmp_have_cblas" = "xyes"; then
      cs_have_blas=yes
    fi

  fi

  # Cleanup if no BLAS found

  if test "x$cs_have_blas" != "xyes"; then
    with_blas_type=no
    if test "x$with_blas" != "xcheck" ; then
      AC_MSG_FAILURE([BLAS support is requested, but test for BLAS failed!])
    else
      AC_MSG_WARN([no BLAS support])
    fi
    BLAS_LIBS=""
  fi

  CPPFLAGS="$saved_CPPFLAGS"
  LDFLAGS="$saved_LDFLAGS"
  LIBS="$saved_LIBS"

  unset saved_CPPFLAGS
  unset saved_LDFLAGS
  unset saved_LIBS

fi

# MKL provides sparse matrix-vector
# operations (so it may be used by the code_saturne solver)
AM_CONDITIONAL(HAVE_MKL, test x$with_blas_type = xMKL)

AC_SUBST(cs_have_blas)
AC_SUBST(BLAS_CPPFLAGS)
AC_SUBST(BLAS_LDFLAGS)
AC_SUBST(BLAS_LIBS)
AC_SUBST(BLASRUNPATH)

])dnl

